<?php
if ( ! defined('ABSPATH') ) exit;

class HBDEV_Budget_Admin_Page {
	public static function register_menu() {
		add_submenu_page(
			'edit.php?post_type=booking',
			__('Budget Dashboard', 'hbdev-budget'),
			__('Dashboard', 'hbdev-budget'),
			'manage_bookings',
			'hbdev-budget-dashboard',
			[__CLASS__, 'render_page'],
			0
		);
		add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_assets']);
	}

	public static function enqueue_assets($hook) {
		// Enqueue nur auf unserer Dashboard-Seite (Top-Level oder als Submenü)
		if (strpos($hook, 'hbdev-budget-dashboard') === false) return;

		wp_enqueue_style(
			'hbdev-budget-dashboard',
			HBDEV_BUDGET_URL . 'assets/css/dashboard.css',
			[],
			HBDEV_BUDGET_VER
		);

		wp_enqueue_script(
			'hbdev-budget-dashboard',
			HBDEV_BUDGET_URL . 'assets/js/dashboard.js',
			['wp-api-fetch'],
			HBDEV_BUDGET_VER,
			true
		);

		wp_localize_script('hbdev-budget-dashboard', 'HBDEV_BUDGET', [
			'restUrl' => esc_url_raw( rest_url('hbdev-bookings/v1/stats') ),
			'nonce'   => wp_create_nonce('wp_rest'),
			'currentMonth' => (new DateTimeImmutable('now', wp_timezone()))->format('Y-m'),
		]);
	}

	public static function render_page() {
		if ( ! current_user_can('manage_bookings') ) {
			wp_die(__('Kein Zugriff.', 'hbdev-budget'));
		}

		$ym = isset($_GET['month']) ? sanitize_text_field($_GET['month']) : '';
		$ym = HBDEV_Budget_Helpers::sanitize_ym($ym);
		?>
		<div class="wrap hbdev-bookings-wrap">
			<?php $icon = HBDEV_Budget_Helpers::get_page_dashicon_class('hbdev-budget-dashboard'); ?>
			<h1>
				<?php if ($icon): ?><span class="dashicons <?php echo esc_attr($icon); ?>" style="vertical-align:middle; margin-right:6px;"></span><?php endif; ?>
				<?php esc_html_e('Budget – Dashboard', 'hbdev-budget'); ?>
			</h1>

			<div class="hbdev-controls">
				<label for="hbdev-month"><?php esc_html_e('Auswertungsmonat', 'hbdev-budget'); ?></label>
				<input type="month" id="hbdev-month" value="<?php echo esc_attr($ym); ?>" />
				<button class="button button-primary" id="hbdev-apply">
					<?php esc_html_e('Anwenden', 'hbdev-budget'); ?>
				</button>
			</div>

			<div id="hbdev-kpis" class="hbdev-grid">
				<div class="card"><div class="card-title">Umsatz</div><div class="card-value" id="kpi-total">–</div></div>
				<div class="card"><div class="card-title">Einnahmen</div><div class="card-value" id="kpi-income">–</div></div>
				<div class="card"><div class="card-title">Ausgaben</div><div class="card-value" id="kpi-expense">–</div></div>
				<div class="card"><div class="card-title">Saldo</div><div class="card-value" id="kpi-balance">–</div></div>
				<div class="card"><div class="card-title">Eröffnungssaldo</div><div class="card-value" id="kpi-opening">–</div></div>
				<div class="card"><div class="card-title">Schlusssaldo</div><div class="card-value" id="kpi-closing">–</div></div>
			</div>

			<div class="hbdev-charts">
				<div class="chart-card">
					<div class="chart-title">Top-Kategorien (Ausgaben)</div>
					<div class="chart-controls">
						<label for="hbdev-chart-type"><?php esc_html_e('Darstellung', 'hbdev-budget'); ?></label>
						<select id="hbdev-chart-type">
							<option value="bar"><?php esc_html_e('Balken', 'hbdev-budget'); ?></option>
							<option value="pie"><?php esc_html_e('Torte', 'hbdev-budget'); ?></option>
						</select>
					</div>
					<div class="chart-row">
						<canvas id="chart-expense-cats" width="400" height="320" aria-label="Top Ausgabenkategorien (Balken)"></canvas>
						<canvas id="chart-expense-cats-pie" width="400" height="320" aria-label="Top Ausgabenkategorien (Torte)"></canvas>
					</div>
				</div>
				<div class="chart-card">
					<div class="chart-title">Verlauf im Monat</div>
					<canvas id="chart-daily" width="800" height="320" aria-label="Täglicher Verlauf"></canvas>
				</div>
			</div>

			<div class="hbdev-table">
				<h2><?php esc_html_e('Details (Gruppiert nach Kategorie)', 'hbdev-budget'); ?></h2>
				<table class="widefat">
					<thead><tr><th>Kategorie</th><th>Anzahl</th><th>Summe</th></tr></thead>
					<tbody id="tbl-cats"><tr><td colspan="3">–</td></tr></tbody>
				</table>
			</div>
		</div>
		<?php
	}
}
