HBDev Budget – WordPress Plugin

HBDev Budget hilft dir, deine monatlichen Ausgaben sowie wiederkehrende Abonnements ("Abos") zu erfassen, auszuwerten und zu optimieren. Der Fokus liegt auf einfacher Bedienung im WordPress‑Backend, übersichtlichen Dashboards und Datenschutz: Standardmäßig siehst nur du deine eigenen Daten.


Inhalt
- Überblick
- Funktionen
- Systemvoraussetzungen
- Installation und Update
- Erste Schritte
- Rollen & Berechtigungen
- Datenschutz-Hinweise
- Screenshots
- Häufige Fragen (FAQ)
- Support & Links


Überblick
HBDev Budget ergänzt dein WordPress um zwei verwaltete Bereiche im Admin-Menü:
- Budget (Buchungen): Einträge für Einnahmen und Ausgaben, jeweils mit Datum, Betrag und Kategorie
- Abos: Verwaltung wiederkehrender Zahlungen (z. B. Streaming, SaaS, Versicherungen) mit eigener Maske

Ein Dashboard zeigt dir monatliche Kennzahlen (Umsatz, Einnahmen, Ausgaben, Salden), Top‑Kategorien sowie den Tagesverlauf. Kategorien sind frei definierbar und hierarchisch (z. B. Einnahmen > Gehalt bzw. Ausgaben > Wohnen > Miete).


Funktionen
- Custom Post Types: Buchungen (booking) und Abos (subscription)
- Taxonomie booking_type für Kategorien (hierarchisch, beliebig erweiterbar)
- Dashboard mit KPIs, Top‑Ausgabenkategorien (Balken/Torte) und Monatsverlauf
- Komfortable Erfassung von Buchungen (Datum, Betrag) und Abos
- Strenges Eigentumsmodell: Nutzer sehen und bearbeiten standardmäßig nur ihre eigenen Einträge
- Benutzerrollen für Viewer/Manager sowie automatische Sekundärrolle für neue Nutzer
- Automatische Caching-Strategie für schnelle Auswertungen, intelligente Invalidierung bei Änderungen
- Keine Frontend-Ausgabe – alles läuft im Backend
- Integrierter Update-Mechanismus (Plugin Update Checker)


Systemvoraussetzungen
- WordPress: ab 6.2 (getestet bis 6.8)
- PHP: ab 8.0
- Datenbank: wie von deiner WordPress‑Installation unterstützt


Installation und Update
Installation
1) ZIP herunterladen: https://www.dev-becker.de/downloads/hbdev-budget.zip
2) In WordPress: Plugins > Installieren > Plugin hochladen > ZIP auswählen > Installieren > Aktivieren

Manuelle Installation per FTP ist ebenfalls möglich: Entpacke die ZIP und lade den Ordner hbdev-budget in wp-content/plugins/, dann in WordPress aktivieren.

Updates
- Das Plugin nutzt einen integrierten Update-Mechanismus. WordPress prüft automatisch gegen: https://www.dev-becker.de/updates/hbdev-budget.json
- Changelogs werden bevorzugt vom Update-Server geladen, alternativ aus einer im Paket enthaltenen Datei (falls vorhanden)
- Empfohlen: Regelmäßig über das WordPress-Backend aktualisieren


Erste Schritte
1) Kategorien anlegen
   - Gehe zu Buchungs-Kategorien (Taxonomie booking_type)
   - Lege zwei Hauptkategorien an: Einnahmen und Ausgaben
   - Darunter kannst du beliebige Unterkategorien anlegen (z. B. Ausgaben > Wohnen > Miete)

2) Buchungen erfassen
   - Menü: Budget > Buchungen > Erstellen
   - Datum und Betrag eingeben, passende Kategorie(n) auswählen
   - Hinweis: Beträge können Dezimalstellen mit Punkt oder Komma enthalten

3) Abos verwalten
   - Menü: Budget > Abos erstellen/bearbeiten
   - Lege wiederkehrende Zahlungen an und ordne sie Kategorien zu

4) Dashboard nutzen
   - Menü: Budget > Dashboard
   - Wähle oben den Auswertungsmonat und erhalte KPIs, Top‑Kategorien (Ausgaben) und den Tagesverlauf


Rollen & Berechtigungen
- hbdev_budget_user (Sekundärrolle): Wird neuen Benutzern automatisch zugewiesen; erlaubt das Verwalten eigener Buchungen/Abos sowie die Dashboard‑Ansicht.
- booking_viewer: Darf lesen und das Dashboard sehen (primär für reine Einsicht).
- booking_manager: Darf eigene Buchungen/Abos erstellen/bearbeiten/löschen und das Dashboard sehen.

Wichtige Hinweise
- Eigentum: Listenansichten und Speichern sind so eingeschränkt, dass Nutzer nur ihre eigenen Einträge sehen/bearbeiten.
- Kategorien verwalten: Erfordert die Fähigkeit manage_booking_types (Admins haben diese automatisch).


Datenschutz-Hinweise
- Keine Frontend-Ausgabe: Das Plugin zeigt standardmäßig nichts im öffentlichen Bereich deiner Website an.
- Private Daten: Buchungen und Abos sind nicht öffentlich. Zugriff erhält nur, wer im Backend angemeldet und berechtigt ist.
- Deaktivieren/Deinstallieren: Daten werden durch Deaktivieren/Deinstallieren nicht automatisch gelöscht. Bitte exportiere/archiviere vor Änderungen und lösche Daten bei Bedarf manuell.


Screenshots
- Dashboard: https://www.dev-becker.de/updates/assets/screenshots/dashboard-full.png
- Kategorie-Summen: https://www.dev-becker.de/updates/assets/screenshots/kat-summen-full.png
- Abos: https://www.dev-becker.de/updates/assets/screenshots/subscriptions-full.png


Häufige Fragen (FAQ)
Warum sehe ich keine Daten im Dashboard?
- Stelle sicher, dass für den gewählten Monat Buchungen mit Datum/Betrag vorhanden sind und du als Autor dieser Einträge eingeloggt bist.

Wie erfasse ich Einnahmen vs. Ausgaben?
- Du entscheidest das über deine Kategorie-Struktur (z. B. Einnahmen oder Ausgaben als oberste Ebene). Die Auswertung ordnet danach.

Kann ich Daten exportieren?
- Es gibt keinen speziellen Exporter. Du kannst jedoch den WordPress‑Werkzeug „Daten exportieren“ nutzen und die Custom Post Types auswählen (booking, subscription).

Gibt es eine Frontend‑Ansicht oder Shortcodes?
- Nein, aktuell nicht. Das Plugin konzentriert sich auf die Backend‑Verwaltung.

Wie aktualisiere ich das Plugin?
- Wie gewohnt über das WordPress‑Backend. Der Update‑Checker prüft automatisch gegen die oben genannte Update‑URL.


Support & Links
- Projektseite: https://www.dev-becker.de/hbdev-budget/
- Autor: Heiko Becker – https://www.dev-becker.de/
- Mindestanforderungen (Referenz): WordPress ≥ 6.2, PHP ≥ 8.0

Version
- Aktuelle Plugin‑Version: 1.1.2
